<?php get_header(); ?>	

<?php if ( wptouch_classic_is_custom_latest_posts_page() ) { ?>

	<?php wptouch_classic_custom_latest_posts_query(); ?>
	<?php locate_template( 'blog-loop.php', true ); ?>

<?php } else { ?>

	<?php if ( wptouch_have_posts() ) { ?>
	
		<?php wptouch_the_post(); ?>

		<div class="<?php wptouch_post_classes(); ?> page-title-area rounded-corners-8px">
			<div class="title-area">
				<?php if ( classic_use_thumbnail_icons() && classic_thumbs_on_pages() ) { ?>
					<img src="<?php wptouch_the_post_thumbnail(); ?>" class="attachment-post-thumbnail default-thumbnail" alt="post thumbnail" />	
				<?php } elseif ( wptouch_page_has_icon() ) { ?>
					<img src="<?php wptouch_page_the_icon(); ?>" alt="<?php the_title(); ?>-page-icon" class="page-icon" />
				<?php } ?>
	
				<h2><?php wptouch_the_title(); ?></h2>
	
				<?php wp_link_pages( __( 'Pages in the article:', 'wptouch-pro' ), '', 'number' ); ?>
			</div>
			
			<div class="<?php wptouch_content_classes(); ?>">
				<?php wptouch_the_content(); ?>
			</div>
			
			<?php wp_link_pages( 'before=<div class="post-page-nav">' . __( "Pages", "wptouch-pro" ) . ':&after=</div>&next_or_number=number&pagelink=page %&previouspagelink=&raquo;&nextpagelink=&laquo;' ); ?>          

		</div><!-- wptouch_posts_classes() -->

	<?php } ?>
	
	<?php if ( classic_show_comments_on_pages() ) { ?>
		<?php comments_template(); ?>
	<?php } ?>
<?php } ?>

<?php get_footer(); ?>